import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Create a figure and axis
fig, ax = plt.subplots(figsize=(8, 10))

# Define the grid size
rows, cols = 5, 4

# Define the colors for the tiles
white_color = 'white'
black_color = 'black'
unpainted_color = 'lightgreen'

# Define the goal state tile colors
goal_tile_colors = {
    'tile_1-1': white_color, 'tile_1-2': black_color, 'tile_1-3': white_color, 'tile_1-4': black_color,
    'tile_2-1': black_color, 'tile_2-2': white_color, 'tile_2-3': black_color, 'tile_2-4': white_color,
    'tile_3-1': white_color, 'tile_3-2': black_color, 'tile_3-3': white_color, 'tile_3-4': black_color,
    'tile_4-1': black_color, 'tile_4-2': white_color, 'tile_4-3': black_color, 'tile_4-4': white_color,
    'tile_0-1': unpainted_color, 'tile_0-2': unpainted_color, 'tile_0-3': unpainted_color, 'tile_0-4': unpainted_color,
}

# Draw the tiles
for row in range(rows):
    for col in range(cols):
        tile_id = f'tile_{row}-{col+1}'
        color = goal_tile_colors[tile_id]
        rect = patches.Rectangle((col, rows-row-1), 1, 1, linewidth=1, edgecolor='black', facecolor=color)
        ax.add_patch(rect)
        ax.text(col + 0.5, rows-row-0.5, tile_id, ha='center', va='center', fontsize=8, color='black' if color == white_color or color == unpainted_color else 'white')

# Draw the robots below the grid indicating "no constraints"
robot1_color = 'white'
robot2_color = 'black'
robot_positions = {
    'robot1': (-1.5, -1),  # Placed below the grid
    'robot2': (-0.5, -1),  # Placed below the grid
}

for robot, (col, row) in robot_positions.items():
    color = robot1_color if robot == 'robot1' else robot2_color
    circle = patches.Circle((col + 0.5, row), 0.3, edgecolor='black', facecolor=color)
    ax.add_patch(circle)
    ax.text(col + 0.5, row - 0.2, robot, ha='center', va='center', fontsize=8, color='black' if color == white_color else 'white')
    ax.text(col + 0.5, row - 0.4, "No constraints", ha='center', va='center', fontsize=8, color='black')

# Set limits and labels
ax.set_xlim(-2, cols)
ax.set_ylim(-2, rows)
ax.set_xticks([])
ax.set_yticks([])

# Add legend
legend_elements = [
    patches.Patch(facecolor=white_color, edgecolor='black', label='White Painted Tile'),
    patches.Patch(facecolor=black_color, edgecolor='black', label='Black Painted Tile'),
    patches.Patch(facecolor=unpainted_color, edgecolor='black', label='Unpainted Tile (Row 0)'),
    patches.Patch(facecolor=robot1_color, edgecolor='black', label='Robot1 (White)'),
    patches.Patch(facecolor=robot2_color, edgecolor='black', label='Robot2 (Black)'),
]
ax.legend(handles=legend_elements, loc='upper right', bbox_to_anchor=(1.3, 1))

# Save the figure
plt.savefig('tiles/one_shot/goal_diagram_code/attempts/goal_diagram_attempt_21.png', bbox_inches='tight')
plt.show()
# VERIFICATION FAILED:
# Robots are not positioned on row 0 as required in the goal state.
